--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Rules_Base.Spontaneous.Initialization;

with Nomo.Interpreter.Storages.Reading;

with Nomo.Interpreter.Reward_Conditions.Initialization;

package body Nomo.Interpreter.Reward_Rules.Initialization is

   procedure Initialize (This                       : out Reward_Rule;
                         Rule_Storage               : in Full_Rule_Storage;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately) is
      use Storages.Reading;
      use Rules_Base.Spontaneous.Initialization;
      use Internal_Messages.Conclusions.Instantaneous.Initialization;
      use Reward_Conditions.Initialization;
   begin
      Initialize (Spontaneous_Rule (This), Rule_Storage);
      Initialize (This.Conclusion,
                  Get_Internal_Conclusion (Rule_Storage).all);
      Initialize (This.Condition,
                  Get_Internal_Condition (Rule_Storage).all,
                  Get_Internal_Condition_Types (Rule_Storage).all,
                  Get_Internal_Condition_Properties (Rule_Storage).all,
                  Get_Internal_Premises_Number (Rule_Storage),
                  Get_Fitting_Nbr (Rule_Storage),
                  Matchmaker_Ptr,
                  Excitatory_Specificity_Log,
                  Inhibitory_Specificity_Log);
   end Initialize;

end Nomo.Interpreter.Reward_Rules.Initialization;
