--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Gen_Types_Index;

private with Nomo.Type_Categories;

private generic
   with package Types_Index is new Gen_Types_Index (<>);
   use Types_Index;
   Number_Of_Input_Types : Type_Index;
package Nomo.Gen_Time_Log_Header is

   subtype Internal_Type_Index is Type_Index range Number_Of_Input_Types + 1 .. Type_Index'Last;

private

   Premises_Maximum : Natural;
   Components_Maximum : Natural;

   use Type_Categories;

   Dictionary : array (Internal_Type_Index'Range) of Type_Category;

end Nomo.Gen_Time_Log_Header;
