--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with System;

with Nomo.Interpreter.Components_Index;

with Nomo.Interpreter.External_Messages;

with Nomo.Numerics.Times;

private with Nomo.Interpreter.External_Events_Index.Arrays;

package Nomo.Interpreter.External_Events_Index.Registers is

   use External_Messages;

   type External_Register is tagged limited private;

   function Get_Current_Event (This : in External_Register) return not null access constant External_Message;
   pragma Inline (Get_Current_Event);

   procedure Is_Refreshed (This   : in out External_Register;
                           Answer : out Boolean);
   --  Mets "Answer"  vrai si un nouvel vnement est arriv depuis le
   --  dernier appelle de cette procedure.

   use Components_Index;

   procedure Put_Event (This    : in out External_Register;
                        Content : in System.Address;
                        Size    : in Component_Index);
   pragma Precondition(System."/=" (System.Null_Address, Content));

   use Numerics.Times;

   procedure Update (This : in out External_Register;
                     T    : in Positive_Time);

private

   type Times is array (External_Event_Index'Range) of Positive_Time;

   use Arrays;

   type External_Register is tagged limited record
      Current_Evidence : External_Event_Index := External_Event_Index'Last;
      Refreshed        : Boolean := False;
      Trace            : External_Events;
      Arrival_Times    : Times := (others => Positive_Time'First);
      Writing_Index    : External_Event_Index := External_Event_Index'First;
      pragma Atomic (Writing_Index);
   end record;
   --  "Input_Type" est une mmoire circulaire de taille fixe.

end Nomo.Interpreter.External_Events_Index.Registers;
