--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Interpreter.Conditions_Base.Evaluation;

with Nomo.Interpreter.Conditions_Base.Checking;

with Nomo.Interpreter.Event_Memory.Internal.Checking;

package body Nomo.Interpreter.Check_Conditions is

   function Are_Possibly_Ongoing  (Prediction_Type_Linked : in Prediction_Type_Index) return Boolean renames Event_Memory.Internal.Checking.Intentions_Present;

   use Numerics.Reals;

   procedure Evaluate (This  : in out Check_Condition) is
      use Conditions_Base.Evaluation;
      Inhibitory_Score    : Positive_Real := 0.0;
      Excitatory_Distance : Positive_Real := 0.0;
   begin
      This.Ongoing := Event_Memory.Internal.Checking.Is_Ongoing (This.Prediction_Type, This.Prediction_Information);
      Reset_Score (Condition_Base (This));
      if This.Ongoing then
         Evaluate_Internal_Exciting_Intentions (Condition_Base (This), Inhibitory_Score, Excitatory_Distance);
         if Inhibitory_Score < 1.0 then
            Evaluate_Internal_Inhibiting_Intentions (Condition_Base (This), Inhibitory_Score);
            if Inhibitory_Score < 1.0 then
               Evaluate_Internal_Inhibiting_Evidences (Condition_Base (This), Inhibitory_Score);
               if Inhibitory_Score < 1.0 then
                  Evaluate_Internal_Exciting_Evidences (Condition_Base (This), Inhibitory_Score, Excitatory_Distance);
                  if Inhibitory_Score < 1.0 then
                     Subtract (Condition_Base (This), Excitatory_Distance, Inhibitory_Score);
                  end if;
               end if;
            end if;
         end if;
      end if;
   end Evaluate;

   function Get_New_Time_Span (This : in Check_Condition) return Positive_Time_Interval is
   begin
      return This.New_Time_Span;
   end Get_New_Time_Span;

   function Get_New_Bonus (This : in Check_Condition) return Positive_Time_Interval is
   begin
      return This.New_Bonus;
   end Get_New_Bonus;

   function Is_Ongoing (This : in Check_Condition) return Boolean is
   begin
      return This.Ongoing;
   end Is_Ongoing;

   procedure Maximize (This : in out Check_Condition) is
      use Conditions_Base.Checking;
   begin
      Maximize (Condition_Base (This), This.Candidates, This.Landmark_premise, This.New_Time_Span, This.New_Bonus);
   end Maximize;

   procedure Note (This : in out Check_Condition) is
      use Conditions_Base.Checking;
   begin
      Note (Condition_Base (This), This.Candidates);
   end Note;

end Nomo.Interpreter.Check_Conditions;
