--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Gen_Rules_Directories.Searching;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Searching);

package body Nomo.Interpreter.Gen_Clusters_Base.Perceptive_Loading is

   function Has_Space (This : in Cluster_Base) return Boolean is
   begin
      return Local_Insertion.Has_Space (Rules_Directory (This.Directory));
   end Has_Space;

   procedure Load (This             : in out Cluster_Base;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage;
                   Input_Type       : in Input_Type_Index) is
      use Local_Insertion;
      Excitatory_Specificity_Log : Real_Accurately;
      Inhibitory_Specificity_Log : Real_Accurately;
   begin
      Initialize (Get_New_Reference (Rules_Directory (This.Directory)).all,
                  Rule_Storage_Ptr.all,
                  This.Matchmaker'Access,
                  Excitatory_Specificity_Log,
                  Inhibitory_Specificity_Log,
                  Input_Type);
      Insert (Rules_Directory (This.Directory), Excitatory_Specificity_Log, Inhibitory_Specificity_Log);
   end Load;

   package Local_Searching is new Local_Rules_Directories.Searching (Is_Equal);

   function Get_Perception (This        : in Cluster_Base;
                            Information : in Positive_Integer) return Rule_Ptr is
      use Local_Searching;
   begin
      return Get_Rule (Rules_Directory (This.Directory), Information);
   end Get_Perception;

end Nomo.Interpreter.Gen_Clusters_Base.Perceptive_Loading;
