--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Fitting;

generic
package Nomo.Gen_External_Messages.Premises.Loading is

   use Numerics.Fitting;

   procedure Set_Component (This        : in out External_Premise;
                            I           : in Component_Index;
                            Information : in Real;
                            Tolerance   : in Strictly_Positive_Real;
                            Fitting_Nbr : in Count);
   pragma Precondition ((I = Component_Index'First and I = This.Size) or This.Size = Component_Index'Pred(I));

end Nomo.Gen_External_Messages.Premises.Loading;
