--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Gen_Operators;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Reader.Parameters;
pragma Elaborate_All (Nomo.Reader.Parameters);

private with Nomo.Reader.Gen_Operators;
pragma Elaborate_All (Nomo.Reader.Gen_Operators);

package Nomo.Interpreter.Plant.Operators is

   package Operators_Description is new Gen_Operators (Reader.Parameters.Get_Number_Of_External_Operators,
                                                       Reader.Parameters.Get_Number_Of_Internal_Operators,
                                                       Types_Index.Ranges.Internal_Type_Index);

   subtype Operator_Without_Parameter is Operators_Description.Operator_Without_Parameter;

   subtype Affectation_Operators is Operator_Without_Parameter range Operators_Description.Get_Before .. Operators_Description.Get_There;

   External_Operators_With_Parameters : constant Operators_Description.External_Operators;
   Internal_Operators_With_Parameters : constant Operators_Description.Internal_Operators;

private

   package Reader_Operators is new Reader.Gen_Operators (Operators_Description.External_Operators,
                                                         Operators_Description.Internal_Operators);

   External_Operators_With_Parameters : constant Operators_Description.External_Operators := Reader_Operators.Get_External_Operators;
   Internal_Operators_With_Parameters : constant Operators_Description.Internal_Operators := Reader_Operators.Get_Internal_Operators;

end Nomo.Interpreter.Plant.Operators;
