#!/bin/bash
cd $(dirname $0)

if [ -f libnomointerpreter.so ]
then
    rm -f libnomointerpreter.so
fi

if [ -f nomointerpreter.dll ]
then
    rm -f nomointerpreter.dll
fi

cd ../../src/nomointerpreter

export PATH=/usr/gnat/bin:$PATH
export LIBRARY_PATH=/usr/lib/i386-linux-gnu:$LIBRARY_PATH 

echo Build dynamic library nomointerpreter

gnatmake -v -z nomo-interpreter-kernel.adb -I. -I../standard_random -cargs -gnatw.edl -gnatf -gnat05 -gnatyabcefhiklrs -gnatQ -fdata-sections -ffunction-sections -O2 -gnatVn -gnatp -gnatn -funroll-loops -bargs -n -x -v -Lnomointerpreter -largs -s -shared -g -Wl -fPIC --gc-sections

rm -f b~nomo-interpreter-kernel.ads
rm -f b~nomo-interpreter-kernel.adb
rm -f b~nomo-interpreter-kernel.ci
rm -f *.o
rm -f *.ali

mv nomo-interpreter-kernel ../../build/nomointerpreter/libnomointerpreter.so

cd ../../build/nomotools/helloworld
if [ ! -f HelloWorld.seed ]
then
    bash helloworld.sh
fi
cp HelloWorld.seed ../../nomointerpreter/helloworld
cd ../../nomointerpreter

exit 0
