<?xml version="1.0" encoding="utf-8" ?>
<!--
  Copyright (2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Construit le programme d'un automate avec le modèle associé. Le paramètre correspond au chemin du modèle de base de tout automate.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:automaton="http://www.nomoseed.org/automaton" xmlns:program="http://www.nomoseed.org/program" xmlns:sdk="http://www.nomoseed.org/sdk" xmlns:project="http://www.nomoseed.org/project">
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>
	<xsl:param name="base" select="'formalisms/automaton'"/>
	<xsl:variable name="model" select="/program:program/@name"/>
	<xsl:template match="/">
		<xsl:apply-templates select="program:program/program:sdk/sdk:formalism/automaton:automaton"/>
	</xsl:template>
	<xsl:template match="automaton:automaton">
		<xsl:element name="program" namespace="http://www.nomoseed.org/program">
			<xsl:attribute name="name">
				<xsl:value-of select="/program:program/@name"/>
			</xsl:attribute>
			<xsl:copy-of select="/program:program/project:header"/>
			<xsl:element name="body" namespace="http://www.nomoseed.org/program">
				<xsl:element name="models" namespace="http://www.nomoseed.org/program">
					<xsl:element name="new" namespace="http://www.nomoseed.org/program">
						<xsl:attribute name="instance">
							<xsl:value-of select="$model"/>
						</xsl:attribute>
						<xsl:call-template name="model">
							<xsl:with-param name="base" select="$base"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:element>
				<xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
					<xsl:call-template name="initial">
						<xsl:with-param name="state" select="automaton:state[position() = 1]/@name"/>
						<xsl:with-param name="model" select="$model"/>
					</xsl:call-template>
					<xsl:for-each select="automaton:state">
						<xsl:sort select="@name" order="ascending"/>
						<xsl:call-template name="front">
							<xsl:with-param name="state" select="@name"/>
							<xsl:with-param name="model" select="$model"/>
						</xsl:call-template>
					</xsl:for-each>
					<xsl:for-each select="automaton:state">
						<xsl:sort select="@name" order="ascending"/>
						<xsl:variable name="name" select="@name"/>
						<xsl:element name="scheme" namespace="http://www.nomoseed.org/program">
							<xsl:attribute name="name">
								<xsl:value-of select="$name"/>
							</xsl:attribute>
							<xsl:for-each select="automaton:transition">
								<xsl:call-template name="transition">
									<xsl:with-param name="state" select="$name"/>
									<xsl:with-param name="model" select="$model"/>
									<xsl:with-param name="event" select="@event"/>
									<xsl:with-param name="target" select="@target"/>
									<xsl:with-param name="front" select="'true'"/>
								</xsl:call-template>
								<xsl:call-template name="transition">
									<xsl:with-param name="state" select="$name"/>
									<xsl:with-param name="model" select="$model"/>
									<xsl:with-param name="event" select="@event"/>
									<xsl:with-param name="target" select="@target"/>
									<xsl:with-param name="front" select="''"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:element>
					</xsl:for-each>
				</xsl:element>
			</xsl:element>
			<xsl:copy-of select="/program:program/program:sdk"/>
		</xsl:element>
	</xsl:template>
	<xsl:template name="initial">
		<xsl:param name="state"/>
		<xsl:param name="model"/>
		<xsl:element name="rule" namespace="http://www.nomoseed.org/program">
			<xsl:attribute name="name">
				<xsl:value-of select="'initialize'"/>
			</xsl:attribute>
			<xsl:attribute name="relevance">
				<xsl:value-of select="'0.0'"/>
			</xsl:attribute>
			<xsl:element name="conclusion" namespace="http://www.nomoseed.org/program">
				<xsl:attribute name="category">
					<xsl:value-of select="'conception'"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="$model"/>
				</xsl:attribute>
				<xsl:attribute name="type">
					<xsl:value-of select="'state'"/>
				</xsl:attribute>
				<xsl:element name="information" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="$state"/>
					</xsl:attribute>
					<xsl:attribute name="delay">
						<xsl:value-of select="0"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template name="front">
		<xsl:param name="state"/>
		<xsl:param name="model"/>
		<xsl:element name="rule" namespace="http://www.nomoseed.org/program">
			<xsl:attribute name="name">
				<xsl:value-of select="$state"/>
			</xsl:attribute>
			<xsl:element name="premise" namespace="http://www.nomoseed.org/program">
				<xsl:attribute name="category">
					<xsl:value-of select="'conception'"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="$model"/>
				</xsl:attribute>
				<xsl:attribute name="type">
					<xsl:value-of select="'state'"/>
				</xsl:attribute>
				<xsl:element name="information" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="$state"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'0'"/>
					</xsl:attribute>
				</xsl:element>
				<xsl:element name="credibility" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="'1'"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'INF'"/>
					</xsl:attribute>
				</xsl:element>
				<xsl:element name="timespan" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="'0'"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'0'"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:element name="conclusion" namespace="http://www.nomoseed.org/program">
				<xsl:attribute name="category">
					<xsl:value-of select="'conception'"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="$model"/>
				</xsl:attribute>
				<xsl:attribute name="type">
					<xsl:value-of select="'state'"/>
				</xsl:attribute>
				<xsl:element name="information" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="$state"/>
					</xsl:attribute>
					<xsl:attribute name="delay">
						<xsl:value-of select="'MAX'"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template name="transition">
		<xsl:param name="state"/>
		<xsl:param name="event"/>
		<xsl:param name="target"/>
		<xsl:param name="model"/>
		<xsl:param name="front"/>
		<xsl:element name="rule" namespace="http://www.nomoseed.org/program">
			<xsl:attribute name="name">
				<xsl:choose>
					<xsl:when test="$front">
						<xsl:value-of select="concat($state,'_',$event,'_',$target,'_front')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($state,'_',$event,'_',$target)"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:element name="premise" namespace="http://www.nomoseed.org/program">
				<xsl:attribute name="category">
					<xsl:value-of select="'conception'"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="$model"/>
				</xsl:attribute>
				<xsl:attribute name="type">
					<xsl:value-of select="'state'"/>
				</xsl:attribute>
				<xsl:element name="information" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="$state"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'0'"/>
					</xsl:attribute>
				</xsl:element>
				<xsl:element name="credibility" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="'1'"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'INF'"/>
					</xsl:attribute>
				</xsl:element>
				<xsl:element name="timespan" namespace="http://www.nomoseed.org/program">
					<xsl:choose>
						<xsl:when test="$front">
							<xsl:attribute name="value">
								<xsl:value-of select="'0'"/>
							</xsl:attribute>
							<xsl:attribute name="tolerance">
								<xsl:value-of select="'0'"/>
							</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="value">
								<xsl:value-of select="'-1'"/>
							</xsl:attribute>
							<xsl:attribute name="tolerance">
								<xsl:value-of select="'INF'"/>
							</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:element>
			</xsl:element>
			<xsl:element name="premise" namespace="http://www.nomoseed.org/program">
				<xsl:attribute name="category">
					<xsl:value-of select="'conception'"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="$model"/>
				</xsl:attribute>
				<xsl:attribute name="type">
					<xsl:value-of select="'event'"/>
				</xsl:attribute>
				<xsl:element name="information" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="$event"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'0'"/>
					</xsl:attribute>
				</xsl:element>
				<xsl:element name="credibility" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="'1'"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'INF'"/>
					</xsl:attribute>
				</xsl:element>
				<xsl:element name="timespan" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="'0'"/>
					</xsl:attribute>
					<xsl:attribute name="tolerance">
						<xsl:value-of select="'0'"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:element name="conclusion" namespace="http://www.nomoseed.org/program">
				<xsl:attribute name="category">
					<xsl:value-of select="'conception'"/>
				</xsl:attribute>
				<xsl:attribute name="model">
					<xsl:value-of select="$model"/>
				</xsl:attribute>
				<xsl:attribute name="type">
					<xsl:value-of select="'state'"/>
				</xsl:attribute>
				<xsl:element name="information" namespace="http://www.nomoseed.org/program">
					<xsl:attribute name="value">
						<xsl:value-of select="$target"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template name="model">
		<xsl:param name="base"/>
		<xsl:element name="model" namespace="http://www.nomoseed.org/model">
			<xsl:attribute name="name">
				<xsl:value-of select="$model"/>
			</xsl:attribute>
			<xsl:element name="base" namespace="http://www.nomoseed.org/model">
				<xsl:element name="xi:include">
					<xsl:attribute name="href">
						<xsl:value-of select="concat($base,'/formalisms/automaton/automaton.mod')"/>
					</xsl:attribute>
					<xsl:attribute name="parse">
						<xsl:value-of select="'xml'"/>
					</xsl:attribute>
				</xsl:element>
			</xsl:element>
			<xsl:element name="definition" namespace="http://www.nomoseed.org/model">
				<xsl:element name="conception_type" namespace="http://www.nomoseed.org/model">
					<xsl:attribute name="name">
						<xsl:value-of select="'state'"/>
					</xsl:attribute>
					<xsl:element name="items" namespace="http://www.nomoseed.org/model">
						<xsl:for-each select="automaton:state">
							<xsl:sort select="@name" order="ascending"/>
							<xsl:element name="item" namespace="http://www.nomoseed.org/model">
								<xsl:attribute name="name">
									<xsl:value-of select="@name"/>
								</xsl:attribute>
							</xsl:element>
						</xsl:for-each>
					</xsl:element>
				</xsl:element>
				<xsl:element name="conception_type" namespace="http://www.nomoseed.org/model">
					<xsl:attribute name="name">
						<xsl:value-of select="'event'"/>
					</xsl:attribute>
					<xsl:element name="items" namespace="http://www.nomoseed.org/model">
						<xsl:for-each select="automaton:state/automaton:transition[not(preceding::automaton:transition/@event = @event) or not(preceding::automaton:transition)]">
							<xsl:sort select="@event" order="ascending"/>
							<xsl:element name="item" namespace="http://www.nomoseed.org/model">
								<xsl:attribute name="name">
									<xsl:value-of select="@event"/>
								</xsl:attribute>
							</xsl:element>
						</xsl:for-each>
					</xsl:element>
				</xsl:element>
			</xsl:element>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>