//  Copyright (2010-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, version 2 of the License.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

var progressSize;
var progressVal;
var progressBar;

window.onscroll = function () { 
	event.preventDefault();
	event.stopPropagation();
	window.scrollTo(0,0);
}

function pause (){
	nomoSDK.pause();
	document.getElementById ("starting").onclick = start;
	document.getElementById ("starting").name = 'start';
	document.getElementById ("controls").setAttribute("class", "box");
}

function reloadData(){
	nomoSDK.reloadData();
}

function setProgressBar(progression){
	if (progression > 100)
	{
		progressSize.style.width = "0px";
		progressVal.innerHTML = "";
	}
	else
	{
		if (progression == 100 && progressVal.innerHTML == "")
			progressSize.style.width = (Math.floor(progressBar.offsetWidth * progression / 100)-30) + "px";
		else
			progressSize.style.width = Math.floor(progressBar.offsetWidth * progression / 100) + "px";
		progressVal.innerHTML = progression + "%";
	}
}

function changeStepsNumber(){
	var step = document.getElementById("stepsNumber").value;
	if (Number(step))
	{
		step = Math.floor(step);
		if (step == 0)
			document.getElementById("stepsNumber").value = 1;
		else if (step < 0)
			document.getElementById("stepsNumber").value = -step;
	}
	else
		document.getElementById("stepsNumber").value = 1;
	nomoSDK.setStepsNumber(document.getElementById("stepsNumber").value);
}

function changeLogFlag(){
	var logFlag = document.getElementById("logFlag").selectedIndex;
	document.getElementById("fileFlag").disabled = "";
	if (logFlag == 0 || logFlag == 2)
	{
		if(!nomoSDK.getHasLogPartialFile()){
			var fileFlag = document.getElementById("fileFlag");
			fileFlag.selectedIndex = 1;
			nomoSDK.setFileFlag(fileFlag.options[fileFlag.selectedIndex].value);
			fileFlag.disabled = "disabled";
		}
	}
	else if (logFlag == 1 || logFlag == 3)
	{
		if(!nomoSDK.getHasLogCompleteFile()){
			var fileFlag = document.getElementById("fileFlag");
			fileFlag.selectedIndex = 0;
			nomoSDK.setFileFlag(fileFlag.options[fileFlag.selectedIndex].value);
			fileFlag.disabled = "disabled";
		}
	}
	nomoSDK.setLogFlag(logFlag);
}

function changeLogPositionFlag(){
	nomoSDK.setLogPositionFlag(document.getElementById("logPositionFlag").selectedIndex);
}

function changeFileFlag(){
	var fileFlag = document.getElementById("fileFlag");
	nomoSDK.setFileFlag(fileFlag.options[fileFlag.selectedIndex].value);
}

function changeFinal(){
	nomoSDK.setFinal(document.getElementById("final").selectedIndex);
}

function changeAnimation(){
	nomoSDK.setAnimation(document.getElementById("animation").selectedIndex);
}

function action (){}