<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ws="http://www.nomoseed.org/worldsquare">
	<xsl:output method="xml" standalone="no" indent="no" encoding="utf-8"/>
	<xsl:variable name="sumSounds">
		<xsl:call-template name="sumSounds">
			<xsl:with-param name="sounds" select="//ws:sound"/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:key name="slabKey" match="ws:slab" use="@id"/>
	<xsl:template match="ws:worldsquare">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:sum_sounds">
		<xsl:copy>
			<xsl:if test="//ws:sound">
				<xsl:attribute name="value">
					<xsl:value-of select="$sumSounds"/>
				</xsl:attribute>
			</xsl:if>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:hue">
		<xsl:copy>
			<xsl:attribute name="value">
				<xsl:value-of select="key('slabKey', ../@on)/@hue"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:bumper">
		<xsl:variable name="x" select="key('slabKey', ../@on)/@x"/>
		<xsl:variable name="y" select="key('slabKey', ../@on)/@y"/>
		<xsl:copy>
			<xsl:call-template name="setInput">
				<xsl:with-param name="cond1" select="/ws:worldsquare/ws:slab[@x = $x and @y = $y - 1]"/>
				<xsl:with-param name="cond2" select="/ws:worldsquare/ws:slab[@x = $x + 1 and @y=$y]"/>
				<xsl:with-param name="cond3" select="/ws:worldsquare/ws:slab[@x = $x and @y = $y + 1]"/>
				<xsl:with-param name="cond4" select="/ws:worldsquare/ws:slab[@x = $x - 1 and @y = $y]"/>
				<xsl:with-param name="direction" select="../@direction"/>
			</xsl:call-template>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:sonar">
		<xsl:variable name="x" select="key('slabKey', ../@on)/@x"/>
		<xsl:variable name="y" select="key('slabKey', ../@on)/@y"/>
		<xsl:copy>
			<xsl:call-template name="setInput">
				<xsl:with-param name="cond1" select="/ws:worldsquare/ws:sphere[@x = $x and $y &gt; @y]"/>
				<xsl:with-param name="cond2" select="/ws:worldsquare/ws:sphere[@x &gt; $x and @y = $y]"/>
				<xsl:with-param name="cond3" select="/ws:worldsquare/ws:sphere[@x = $x and  @y &gt; $y]"/>
				<xsl:with-param name="cond4" select="/ws:worldsquare/ws:sphere[$x &gt; @x and  @y = $y]"/>
				<xsl:with-param name="direction" select="../@direction"/>
			</xsl:call-template>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="ws:slab | ws:sphere | ws:advance | ws:turn_right | ws:turn_left | ws:sound | ws:capture | ws:depose  | ws:strength">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="ws:agent">
		<xsl:copy>
			<xsl:attribute name="on">
				<xsl:value-of select="@on"/>
			</xsl:attribute>
			<xsl:attribute name="direction">
				<xsl:value-of select="@direction"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template name="sumSounds">
		<xsl:param name="sounds"/>
		<xsl:choose>
			<xsl:when test="$sounds">
				<xsl:variable name="value" select="$sounds[1]/@value"/>
				<xsl:variable name="othersSounds">
					<xsl:call-template name="sumSounds">
						<xsl:with-param name="sounds" select="$sounds[position() != 1]"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$value + $othersSounds"/>
			</xsl:when>
			<xsl:otherwise>0</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="setInput">
		<xsl:param name="cond1"/>
		<xsl:param name="cond2"/>
		<xsl:param name="cond3"/>
		<xsl:param name="cond4"/>
		<xsl:param name="direction"/>
		<xsl:choose>
			<xsl:when test="$cond1">
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'1'"/>
					<xsl:with-param name="delta" select="(360 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'0'"/>
					<xsl:with-param name="delta" select="(360 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$cond2">
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'1'"/>
					<xsl:with-param name="delta" select="(360 + 90 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'0'"/>
					<xsl:with-param name="delta" select="(360 + 90 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$cond3">
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'1'"/>
					<xsl:with-param name="delta" select="(360 + 180 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'0'"/>
					<xsl:with-param name="delta" select="(360 + 180 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
			<xsl:when test="$cond4">
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'1'"/>
					<xsl:with-param name="delta" select="(360 + 270 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="setSensor">
					<xsl:with-param name="value" select="'0'"/>
					<xsl:with-param name="delta" select="(360 + 270 - $direction) mod 360"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="setSensor">
		<xsl:param name="value"/>
		<xsl:param name="delta"/>
		<xsl:variable name="orientation">
			<xsl:choose>
				<xsl:when test="$delta = 0">front</xsl:when>
				<xsl:when test="$delta = 90">right</xsl:when>
				<xsl:when test="$delta = 180">back</xsl:when>
				<xsl:when test="$delta = 270">left</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:attribute name="{$orientation}">
			<xsl:value-of select="$value"/>
		</xsl:attribute>
	</xsl:template>
</xsl:stylesheet>
