#!/bin/bash
cd $(dirname $0)

rm -f libnomotools.so
rm -f nomotools.dll
rm -f nomotools.exe
rm -f nomoTools
find  -name '*.xsl' -exec sed -e '/\r$/!s/$/\r/' {} \;

cd ../../src/nomotools

echo Build dynamic library nomotools

export PATH=/usr/gnat/bin:$PATH
export LIBRARY_PATH=/usr/lib/i386-linux-gnu:$LIBRARY_PATH 

gnatmake -v -z nomotools.adb -I. -I../nomointerpreter -I../basic_sax -cargs -gnatw.edl -gnatf -gnat05 -gnatyabcefhiklrs -gnatQ -fdata-sections -ffunction-sections -O2 -gnatVn -gnatp -gnatn -funroll-loops -bargs -n -x -v -Lnomotools -largs -s -shared -g -Wl -fPIC --gc-sections

rm -f b~nomotools.ads
rm -f b~nomotools.adb
rm -f b~nomotools.ci
rm -f nomotools.base
rm -f nomotools.exp
rm -f save.txt
rm -f *.o
rm -f *.ali

mv nomotools ../../build/nomotools/libnomotools.so
export LIBRARY_PATH=../../build/nomotools/:$LIBRARY_PATH

echo Build executable nomotools

export PATH=/usr/local/Trolltech/Qt-4.8.4/bin:$PATH
export C_INCLUDE_PATH=/usr/include/i386-linux-gnu:$C_INCLUDE_PATH
export CPLUS_INCLUDE_PATH=/usr/include/i386-linux-gnu:$CPLUS_INCLUDE_PATH

qmake
make

rm -rf release
rm -rf debug
rm -f Makefile.Release
rm -f Makefile.Debug
rm -f Makefile

mv nomoTools ../../build/nomotools/

cd ../../build/nomointerpreter/helloworld
cp HelloWorld.uni ../../nomotools/helloworld
cd ../../nomotools/helloworld
if [ -f ../.nomoTools ]
then
    bash helloworld.sh
fi
cd ..
cd ../nomotime
if [ -f ../.nomoTime ]
then
    bash build.sh
fi
cp nomoTime ../nomotools
cp libnomointerpreter.so ../nomotools