<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Troisième étape de l'encodage :
	- Reporter la numérotation sur les items de règles
	- Numéroter les règles
	- Expliciter les liens entre les types et la taille des données d'entrée et de sortie.
	- Eliminer les éléments devenus inutiles comme "inputs" ou "outputs".
-->

<xsl:stylesheet version="1.0" xmlns:program="http://www.nomoseed.org/program" xmlns:project="http://www.nomoseed.org/project" xmlns:model="http://www.nomoseed.org/model" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:code="http://www.nomoseed.org/code" xmlns:plant="http://www.nomoseed.org/plant" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="xml" standalone="no" indent="no" encoding="utf-8"/>
	<xsl:variable name="multiplexer" select="code:code/@multiplexer"/>
	<xsl:template match="code:code">
		<xsl:copy>
			<xsl:attribute name="unit">
				<xsl:value-of select="@unit"/>
			</xsl:attribute>
			<xsl:attribute name="multiplexer">
				<xsl:value-of select="@multiplexer"/>
			</xsl:attribute>
			<xsl:attribute name="binaryLocation">
				<xsl:value-of select="@binaryLocation"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:program | model:perceptive_structure | model:conception_type | model:command_type | model:landmark_type">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:predictive_structure">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="target">
				<xsl:value-of select="@target"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:plant_structure">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="model:declaration[@id]">
		<xsl:variable name="type" select="@type"/>
		<xsl:variable name="category" select="@category"/>
		<xsl:variable name="model" select="@model"/>
		<xsl:variable name="rewarded_by" select="../model:rewarded_by | parent::model:declarations/../model:rewarded_by"/>
		<xsl:variable name="predicted_by" select="../model:predicted_by | parent::model:declarations/../model:predicted_by"/>
		<xsl:variable name="twined_with" select="../model:conception_type | ../../model:conception_type[@name!=$type and ../model:declarations]"/>
		<xsl:copy>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="category">
				<xsl:value-of select="@category"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="hue">
				<xsl:value-of select="@hue"/>
			</xsl:attribute>
			<xsl:attribute name="saturation">
				<xsl:value-of select="@saturation"/>
			</xsl:attribute>
			<xsl:attribute name="luminance">
				<xsl:value-of select="@luminance"/>
			</xsl:attribute>
			<xsl:attribute name="id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:if test="$rewarded_by">
				<xsl:attribute name="rewarded_by">
					<xsl:value-of select="$rewarded_by/ancestor::program:*[model:model]//model:declaration[@category='reward' and @type=$rewarded_by/@name]/@id"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="$predicted_by">
				<xsl:attribute name="predicted_by">
					<xsl:value-of select="$predicted_by/ancestor::program:*[model:model]//model:declaration[@category='prediction' and @type=$predicted_by/@name]/@id"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="$twined_with">
				<xsl:attribute name="twined_with">
					<xsl:value-of select="$twined_with/model:declaration/@id"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@category='prediction'">
				<xsl:attribute name="check_associated">
					<xsl:value-of select="../model:declaration[@category='check']/@id"/>
				</xsl:attribute>
				<xsl:attribute name="landmark_associated">
					<xsl:value-of select="../model:declaration[@category='landmark']/@id"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@category='input'">
				<xsl:attribute name="perception_associated">
					<xsl:value-of select="../model:declaration[@category='perception']/@id"/>
				</xsl:attribute>
				<xsl:attribute name="data_size">
					<xsl:value-of select="count(../../model:inputs/model:index)"/>
				</xsl:attribute>
				<xsl:attribute name="components">
					<xsl:for-each select="//model:inputs/model:index[@model=$model and @type=$type]">
						<xsl:value-of select="@name"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="' '"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@category='perception'">
				<xsl:attribute name="input_associated">
					<xsl:value-of select="../model:declaration[@category='input']/@id"/>
				</xsl:attribute>
				<xsl:if test="../../model:command_type">
					<xsl:attribute name="command_associated">
						<xsl:value-of select="../../model:command_type/model:declaration[@category='command']/@id"/>
					</xsl:attribute>
				</xsl:if>
			</xsl:if>
			<xsl:if test="@category='command' and ancestor::model:perceptive_structure">
				<xsl:attribute name="perception_associated">
					<xsl:value-of select="ancestor::model:perceptive_structure//model:declaration[@category='perception']/@id"/>
				</xsl:attribute>
			</xsl:if>
			<xsl:if test="@category='command'">
				<xsl:attribute name="data_size">
					<xsl:choose>
						<xsl:when test="$multiplexer = 'no'">
							<xsl:value-of select="count(../model:outputs/model:index)"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="count(../model:outputs/model:index) + 1"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:attribute name="components">
					<xsl:for-each select="//model:outputs/model:index[@model=$model and @type=$type]">
						<xsl:value-of select="@name"/>
						<xsl:if test="position() != last()">
							<xsl:value-of select="' '"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="*">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="model:model">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="program">
				<xsl:value-of select="@program"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:models/program:new | program:models/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="prototype">
				<xsl:value-of select="@prototype"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:attribute name="number">
				<xsl:value-of select="@number"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:premise">
		<xsl:copy>
			<xsl:attribute name="id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs | program:body | program:models | model:declarations | model:definition | program:rules | program:excitatory | program:inhibitory | program:conclusion | program:intention | program:*[program:rule | program:premise | program:intention] | plant:registers_structure | plant:scope_type | plant:operator_type | plant:other | plant:input | plant:conclusion/plant:*[not(@*)] | plant:premise/plant:*[not(@*)]">
		<xsl:copy>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:item">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
      <xsl:attribute name="base">
        <xsl:value-of select="@base"/>
      </xsl:attribute>
			<xsl:attribute name="id">
				<xsl:value-of select="@id"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:conclusion">
		<xsl:copy>
			<xsl:attribute name="fitting_nbr">
				<xsl:value-of select="@fitting_nbr"/>
			</xsl:attribute>
			<xsl:attribute name="relevance">
				<xsl:value-of select="@relevance"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:premise">
		<xsl:copy>
      <xsl:attribute name="information_tolerance">
        <xsl:value-of select="@information_tolerance"/>
      </xsl:attribute>
      <xsl:attribute name="timespan_tolerance">
        <xsl:value-of select="@timespan_tolerance"/>
      </xsl:attribute>
      <xsl:attribute name="credibility_tolerance">
        <xsl:value-of select="@credibility_tolerance"/>
      </xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:scheme">
		<xsl:copy>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:rule">
		<xsl:copy>
			<xsl:attribute name="fitting_nbr">
				<xsl:value-of select="@fitting_nbr"/>
			</xsl:attribute>
			<xsl:attribute name="name">
				<xsl:value-of select="@name"/>
			</xsl:attribute>
			<xsl:attribute name="relevance">
				<xsl:value-of select="@relevance"/>
			</xsl:attribute>
			<xsl:attribute name="id">
				<xsl:number level="any" count="program:rule"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="plant:information">
  <xsl:variable name="category">
    <xsl:variable name="parent" select="local-name(parent::plant:*)"/>
    <xsl:choose>
    <xsl:when test="contains($parent, '_')">
				<xsl:value-of select="substring-before($parent, '_')"/>
    </xsl:when>
    <xsl:otherwise>
				<xsl:value-of select="$parent"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="$category"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:conception or parent::program:premise/parent::program:intention/parent::program:conception or parent::program:premise/parent::program:conception]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'conception'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:reward or parent::program:premise/parent::program:intention/parent::program:reward or parent::program:premise/parent::program:reward]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'reward'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:command or parent::program:premise/parent::program:intention/parent::program:command or parent::program:premise/parent::program:command]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'command'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[ancestor::program:input]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'input'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:perception or parent::program:premise/parent::program:intention/parent::program:perception or parent::program:premise/parent::program:perception]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'perception'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:prediction or parent::program:premise/parent::program:intention/parent::program:prediction or parent::program:premise/parent::program:prediction]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'prediction'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:check or parent::program:premise/parent::program:intention/parent::program:check or parent::program:premise/parent::program:check]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'check'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:landmark or parent::program:premise/parent::program:intention/parent::program:landmark or parent::program:premise/parent::program:landmark]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'landmark'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[ancestor::program:anomaly]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'anomaly'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:transition or parent::program:premise/parent::program:intention/parent::program:transition or parent::program:premise/parent::program:transition]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'transition'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:other_scope or parent::program:premise/parent::program:intention/parent::program:other_scope or parent::program:premise/parent::program:other_scope or parent::program:conclusion/../parent::program:input_scope or parent::program:premise/parent::program:intention/parent::program:input_scope or parent::program:premise/parent::program:input_scope]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'scope'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="program:information[parent::program:conclusion/../parent::program:other_operator or parent::program:premise/parent::program:intention/parent::program:other_operator or parent::program:premise/parent::program:other_operator or parent::program:conclusion/../parent::program:input_operator or parent::program:premise/parent::program:intention/parent::program:input_operator or parent::program:premise/parent::program:input_operator]">
		<xsl:call-template name="copyInformation">
			<xsl:with-param name="category" select="'operator'"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:key name="declarationKey" match="//model:declaration | //plant:declaration" use="@type"/>
	<xsl:template match="plant:target">
		<xsl:copy>
      <xsl:variable name="model" select="@model"/>
      <xsl:variable name="type" select="@type"/>
      <xsl:variable name="category" select="@category"/>
		  <xsl:variable name="typeId" select="key('declarationKey', @type)[@model=$model and @category=$category]/@id"/>
			<xsl:attribute name="category">
				<xsl:value-of select="@category"/>
			</xsl:attribute>
			<xsl:attribute name="typeId">
				<xsl:value-of select="$typeId"/>
			</xsl:attribute>
		</xsl:copy>
	</xsl:template>
	<xsl:key name="itemKey" match="//model:item | //plant:item" use="@name"/>
	<xsl:template name="copyInformation">
		<xsl:param name="category"/>
		<xsl:variable name="model" select="@model"/>
		<xsl:variable name="type" select="@type"/>
		<xsl:variable name="typeId" select="key('declarationKey', @type)[@model=$model and @category=$category]/@id"/>
		<xsl:variable name="itemId" select="key('itemKey', @value)[@model=$model and @type=$type and ../..//*[@category=$category]]/@id"/>
		<xsl:copy>
			<xsl:attribute name="model">
				<xsl:value-of select="@model"/>
			</xsl:attribute>
			<xsl:choose>
				<xsl:when test="@tolerance">
					<xsl:attribute name="tolerance">
						<xsl:value-of select="@tolerance"/>
					</xsl:attribute>
					<xsl:if test="@next">
						<xsl:attribute name="pos">
							<xsl:value-of select="@pos"/>
						</xsl:attribute>
						<xsl:attribute name="next">
							<xsl:value-of select="@next"/>
						</xsl:attribute>
					</xsl:if>
				</xsl:when>
				<xsl:when test="@delay">
					<xsl:attribute name="delay">
						<xsl:value-of select="@delay"/>
					</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="type">
				<xsl:value-of select="@type"/>
			</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:value-of select="@value"/>
			</xsl:attribute>
			<xsl:attribute name="typeId">
        <xsl:choose>
          <xsl:when test="$typeId != ''">
				    <xsl:value-of select="$typeId"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="key('declarationKey', @type)[@category=$category]/@id"/>
          </xsl:otherwise>
        </xsl:choose>
			</xsl:attribute>
			<xsl:if test="not(@next)">
				<xsl:choose>
					<xsl:when test="@value='*'">
						<xsl:attribute name="itemId">
							<xsl:value-of select="'0'"/>
						</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="itemId">
              <xsl:choose>
                <xsl:when test="$itemId != ''">
							    <xsl:value-of select="$itemId"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:choose>
                    <xsl:when test="$type = 'register_00'">
                      <xsl:value-of select="key('itemKey', @value)[@model=$model and ancestor::plant:input and (../..//*[@category=$category] or contains(local-name(./..), $category) or contains(local-name(./../..), $category))]/@id"/>
                    </xsl:when>
                    <xsl:when test="$type = 'transition' or $type = 'anomaly'">
                      <xsl:value-of select="key('itemKey', @value)[@model=$model and (../..//*[@category=$category] or contains(local-name(./..), $category) or contains(local-name(./../..), $category))]/@id"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="key('itemKey', @value)[@model=$model and ancestor::plant:other and (../..//*[@category=$category] or contains(local-name(./..), $category) or contains(local-name(./../..), $category))]/@id"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:otherwise>
              </xsl:choose>
						</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="program:programs/program:new | program:programs/program:inherite">
		<xsl:copy>
			<xsl:attribute name="instance">
				<xsl:value-of select="@instance"/>
			</xsl:attribute>
			<xsl:attribute name="number">
				<xsl:value-of select="@number"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</xsl:copy>
	</xsl:template>
	<xsl:template match="project:*"/>
	<xsl:template match="model:inputs">
    <xsl:copy-of select="."/>
  </xsl:template>
	<xsl:template match="model:outputs">
    <xsl:copy-of select="."/>
  </xsl:template>
</xsl:stylesheet>
