<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
Génére la table TYPE au format CSV.
-->
<xsl:stylesheet version="1.0" xmlns:code="http://www.nomoseed.org/code" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="text" encoding="utf-8"/>
	<xsl:template match="code:code">
    <xsl:text>type_id, name, category, model, program, hue, saturation, luminance</xsl:text>
    <xsl:text>&#13;&#10;</xsl:text>
		<xsl:apply-templates select="code:types/code:type"/>
	</xsl:template>
	<xsl:template match="code:type">
    <xsl:value-of select="@id"/>
    <xsl:value-of select="concat(', ',@name)"/>
    <xsl:value-of select="concat(', ',@category)"/>
    <xsl:value-of select="concat(', ',@model)"/>
    <xsl:value-of select="concat(', ',@program)"/>
    <xsl:value-of select="concat(', ',@hue)"/>
    <xsl:value-of select="concat(', ',@saturation)"/>
    <xsl:value-of select="concat(', ',@luminance)"/>
    <xsl:text>&#13;&#10;</xsl:text>
	</xsl:template>
</xsl:stylesheet>
