--  Copyright (2008-2014) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Interfaces.C;

with System;

private package Nomo.Embedded.Interpreter.Kernel is

   procedure Initialize (Callbacks : in System.Address);
   pragma Precondition (System."/=" (System.Null_Address, Callbacks));
   pragma Export (Convention => C, Entity => Initialize, External_Name => "nomoInitialize");

   procedure Input (Id   : in Interfaces.C.short;
                    Data : in System.Address);
   pragma Precondition (System."/=" (System.Null_Address, Data));
   pragma Export (Convention => C, Entity => Input, External_Name => "nomoInput");

   procedure Triggers;
   pragma Export (Convention => C, Entity => Triggers, External_Name => "nomoTriggers");

end Nomo.Embedded.Interpreter.Kernel;
