--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Streams.Stream_IO;

package Nomo.File_Properties is

   package Seed is

      Header : constant String := "nomoseed";
      Header_Size : constant Positive := Header'Length;
      subtype String_Header is String (1 .. Header_Size);

      Extension      : constant String := ".seed";
      Extension_Size : constant Positive := Extension'Length;

      type Data_Type is (Engine, Dynamic, Types, Rules, Operator_External, Operator_Internal, Scope_External, Scope_Internal);

      type Data_Counts is array (Data_Type'Range) of Ada.Streams.Stream_IO.Positive_Count;

   end Seed;

   package Log is

      Partial_Rule_Extension : constant String := ".pr";

      Partial_Time_Extension : constant String := ".pt";

      Full_Rule_Extension : constant String := ".fr";

      Full_Time_Extension : constant String := ".ft";

      CVS_Extension : constant String := ".cvs";

      XML_Extension : constant String := ".xml";

      Log_Final_Prefix : constant String := "final_";
      Log_Final_Prefix_Size : constant Positive := Log_Final_Prefix'Length;

   end Log;

   package XML is

      Model_Extension : constant String := ".mod";

      Program_Extension : constant String := ".prg";

      Unit_Extension : constant String := ".uni";

      Knowledge_Base_Extension : constant String := ".bas";

      Inference_Engine_Extension : constant String := ".eng";

      Linked_Unit_Extension : constant String := ".lnk";

      Encoded_Unit_Extension : constant String := ".cod";

   end XML;

end Nomo.File_Properties;
