--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Informations;

with Nomo.Numerics.Fitting;

with Nomo.Interpreter.Premises_Index.Arrays;

limited with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

package Nomo.Interpreter.Check_Conditions.Initialization is

   use Numerics.Informations;

   function Get_Prediction_Information(This : in Check_Condition) return Positive_Integer;

   use Numerics.Accurately;
   use Numerics.Fitting;
   use Premises_Index.Premises_Index_Instance;
   use Premises_Index.Arrays;

   procedure Initialize (This                       : in out Check_Condition;
                         Premises                   : in Internal_Premises;
                         Premises_Types             : in Internal_Premises_Types;
                         Properties                 : in Internal_Premises_Properties;
                         Premises_Number            : in Premise_Index;
                         Fitting_Nbr                : in Count;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately;
                         Prediction_Type            : in Prediction_Type_Index);

end Nomo.Interpreter.Check_Conditions.Initialization;
