--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with System;

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;

with Nomo.Internal_Messages;

private with Nomo.Interpreter.Rules_Base.Spontaneous;

private with Nomo.Interpreter.External_Messages;

private with Nomo.Internal_Messages.Conclusions.Instantaneous;

private with Nomo.Interpreter.Standard_Conditions;

limited private with Nomo.Interpreter.Perception_Rules;

private package Nomo.Interpreter.Command_Rules is

   use Numerics.Accurately;

   use Numerics.Reals;

   type Command_Rule is tagged limited private;

   procedure Adjust (This            : in out Command_Rule;
                     Specificity_Log : in out Real_Accurately);

   procedure Evaluate (This  : in out Command_Rule;
                       Score : out Positive_Real);

   procedure Evaluate (This  : in out Command_Rule;
                       Shift : in Real_Accurately;
                       Score : out Positive_Real);

   function Get_External_Conclusion (This : in Command_Rule) return System.Address;
   pragma Inline (Get_External_Conclusion);

   function Get_Internal_Conclusion (This : in Command_Rule) return not null access constant Internal_Messages.Internal_Message;
   pragma Inline (Get_Internal_Conclusion);

   function Get_Intensity (This : in Command_Rule) return Real_0_To_1;
   pragma Inline (Get_Intensity);

   function Is_Forget (This : in Command_Rule) return Boolean;
   pragma Inline (Is_Forget);

   function Is_Updatable (This : in Command_Rule) return Boolean;
   pragma Inline (Is_Updatable);

   function Is_Upgradable (This : in Command_Rule) return Boolean;
   pragma Inline (Is_Upgradable);

   procedure Reinforce (This     : in out Command_Rule;
                        Quantity : in Real_Accurately_0_To_1);

   procedure Update_External_Conclusion (This : in out Command_Rule);
   pragma Precondition (Is_Upgradable (This));

   procedure Update_Relevance (This : in out Command_Rule);
   pragma Inline (Update_Relevance);

   procedure Update_Relevance (This       : in out Command_Rule;
                               Scores_Sum : in Positive_Real);

private

   use Rules_Base.Spontaneous;
   use External_Messages;
   use Internal_Messages;
   use Internal_Messages.Conclusions.Instantaneous;
   use Standard_Conditions;

   type Command_Rule is new Spontaneous_Rule with record
      External_Conclusion : aliased External_Message;
      Internal_Conclusion : aliased Instantaneous_Conclusion;
      Condition           : Standard_Condition;
      Linked_Perception   : access Perception_Rules.Perception_Rule;
      Is_Upgradable       : Boolean := False;
   end record;

end Nomo.Interpreter.Command_Rules;
