--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Gen_Clusters_Base.Commanding_Loading;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Commanding_Loading);

with Nomo.Interpreter.Gen_Clusters_Base.Initialization;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base.Initialization);

with Nomo.Interpreter.Perceptions_Clusters.Loading;

with Nomo.Interpreter.Perception_Rules;

with Nomo.Interpreter.Command_Rules.Initialization;

package body Nomo.Interpreter.Commands_Clusters.Loading is

   package Local_Initialization is new Commands_Clusters_Base.Initialization;

   procedure Initialize (This         : in out Commands_Cluster;
                         Command_Type : in Command_Type_Index) is
      use Local_Initialization;
   begin
      This.Command_Type := Command_Type;
      Initialize (Cluster_Base (This));
   end Initialize;

   use Perception_Rules;
   use Perceptions_Clusters.Loading;
   use Command_Rules.Initialization;

   package Local_Loading is new Commands_Clusters_Base.Commanding_Loading (Initialize,
                                                                           Get_Perception_Information,
                                                                           Perceptions_Cluster,
                                                                           Perception_Rule,
                                                                           Get_Perception,
                                                                           Initial.Set_Linked_Perception);
   function Has_Space (This : in Commands_Cluster) return Boolean is
   begin
      return Local_Loading.Has_Space (Cluster_Base (This));
   end Has_Space;

   procedure Initialize_Links (This   : in out Commands_Cluster;
                               Target : in Perceptions_Cluster) is
      use Local_Loading;
   begin
      Initialize_Links (Cluster_Base (This), Target);
   end Initialize_Links;

   procedure Load (This             : in out Commands_Cluster;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) is
      use Local_Loading;
   begin
      Load (Cluster_Base (This), Rule_Storage_Ptr, This.Last_Loaded);
   end Load;

   procedure Update_Last_Link (This   : in out Commands_Cluster;
                               Target : in out Perceptions_Cluster) is
      Last_Loaded : Command_Rule renames This.Last_Loaded.all;
   begin
      Inline.Set_Linked_Perception (Last_Loaded, Get_Perception (Target, Get_Perception_Information (Last_Loaded)));
   end Update_Last_Link;

end Nomo.Interpreter.Commands_Clusters.Loading;
