--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Numerics.Accurately;

limited private with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

private with Nomo.Numerics.Fitting;

private with Nomo.Interpreter.Premises_Index.Arrays;

private with Nomo.Interpreter.Premises_Index.Focus.Directories;

private with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

private package Nomo.Interpreter.Conditions_Base is

   type Condition_Base is abstract tagged limited private;

   procedure Evaluate (This  : in out Condition_Base) is abstract;

   use Numerics.Accurately;
   use Numerics.Reals;

   function Get_Credibility (This : in Condition_Base) return Real_0_To_1;
   pragma Inline (Get_Credibility);

   function Get_Score (This : in Condition_Base) return Positive_Real;
   pragma Inline (Get_Score);

   function Get_Specificity_Log (This : in Condition_Base) return Real_Accurately;
   pragma Inline (Get_Specificity_Log);

   function Is_Optimizable (This : in Condition_Base) return Boolean;
   pragma Inline (Is_Optimizable);

   procedure Maximize (This : in out Condition_Base);

private

   use Premises_Index;
   use Numerics.Fitting;
   use Premises_Index.Focus.Directories;

   type Condition_Base is abstract tagged limited record
      Directory           : Premises_Directory;
      Premises            : aliased Arrays.Internal_Premises;
      Fitting_Nbr         : Count;
      Optimizable         : Boolean;
      Specificity_Log     : Real_Accurately;
      Specificity_Log_Min : Real_Accurately;
      Score               : Positive_Real;
      Credibility         : Real_0_To_1 := 0.0;
      Matchmaker_Ptr      : access Internal_Events_Index.Matchmakers.Matchmaker;
   end record;

   Maximum_Of_Maximizations : constant Count := Beginning.Parameters.Get_Maximum_Of_Maximizations;

end Nomo.Interpreter.Conditions_Base;
