--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Epistemic_Memory.Gen_Section is

   procedure Assume (T : in Positive_Time) is
   begin
      for I in Index_Type'Range loop
         if Has_Selection (This (I)) then
            Assume (This (I), T);
         end if;
      end loop;
   end Assume;

   procedure Interpret is
   begin
      for I in Index_Type'Range loop
         Interpret (This (I));
      end loop;
   end Interpret;

   procedure Reinforce (I               : in Index_Type;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1) is
   begin
      Reinforce (This (I), T, First_Landmark, Second_Landmark, Quantity);
   end Reinforce;

end Nomo.Interpreter.Epistemic_Memory.Gen_Section;
