--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Accurately;

with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Reflections_Clusters;

private with Nomo.Interpreter.Epistemic_Memory.Gen_Section;
pragma Elaborate_All(Nomo.Interpreter.Epistemic_Memory.Gen_Section);

private package Nomo.Interpreter.Epistemic_Memory.Reflective is

   use Numerics.Times;
   use Numerics.Accurately;

   procedure Assume (T : in Positive_Time);

   procedure Interpret;

   use Types_Index.Ranges;

   procedure Reinforce (I               : in Reflective_Type_Index;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);

private

   use Reflections_Clusters;

   package Reflective_Epistemic_Memory is new Gen_Section (Reflections_Cluster,
                                                           Reflective_Type_Index,
                                                           Has_Selection,
                                                           Assume,
                                                           Interpret,
                                                           Reinforce);

   procedure Assume (T : in Positive_Time) renames Reflective_Epistemic_Memory.Assume;

   procedure Interpret renames Reflective_Epistemic_Memory.Interpret;

   procedure Reinforce (I               : in Reflective_Type_Index;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1) renames Reflective_Epistemic_Memory.Reinforce;

end Nomo.Interpreter.Epistemic_Memory.Reflective;
