--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.External_Messages.Events;

package body Nomo.Interpreter.External_Events_Index.Registers is

   function Get_Current_Event (This : in External_Register) return not null access constant External_Message is
   begin
      return This.Trace (This.Current_Evidence)'Unchecked_Access;
   end Get_Current_Event;

   procedure Is_Refreshed (This   : in out External_Register;
                           Answer : out Boolean) is
   begin
      Answer := This.Refreshed;
      This.Refreshed := False;
   end Is_Refreshed;

   procedure Put_Event (This    : in out External_Register;
                        Content : in System.Address;
                        Size    : in Component_Index) is
      use External_Messages.Events;
   begin
      Set_Content (This.Trace (This.Writing_Index), Content, Size);
      This.Refreshed := True;
   end Put_Event;

   procedure Update (This : in out External_Register;
                     T    : in Positive_Time) is
   begin
      if This.Refreshed then
         This.Current_Evidence := This.Writing_Index;
         This.Arrival_Times (This.Current_Evidence) := T;
         This.Writing_Index := External_Event_Index (Natural(This.Writing_Index + 1) mod Index_Modulo);
      end if;
   end Update;

end Nomo.Interpreter.External_Events_Index.Registers;
