--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Logging_Flags;

limited with Nomo.Interpreter.Storages;

private with Nomo.Interpreter.Gen_Rules_Directories.Logging;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Logging);

generic
   type Cluster is new Cluster_Base with private;
   with procedure Log_Partial (This       : in Rule;
                               Buffer_Ptr : not null access Storages.Full_Rule_Storage);
   with procedure Log_Full (This       : in Rule;
                            Buffer_Ptr : not null access Storages.Full_Rule_Storage);
package Nomo.Interpreter.Gen_Clusters_Base.Logging is

   use Logging_Flags;

   procedure Log (This       : in Cluster;
                  Buffer_Ptr : not null access Storages.Full_Rule_Storage;
                  Flag       : in Log_Flag);
private

   package Logging_Instance is new Local_Rules_Directories.Logging (Log_Partial,
                                                                    Log_Full);

end Nomo.Interpreter.Gen_Clusters_Base.Logging;
