--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Interfaces.C.Strings;

with System;

with Nomo.Logging_Flags;

private package Nomo.Interpreter.Kernel is

   procedure Initialize (Callbacks : in System.Address;
                         Directory : in Interfaces.C.Strings.chars_ptr;
                         Length    : in Interfaces.C.size_t);
   pragma Precondition (System."/=" (System.Null_Address, Callbacks));
   pragma Export (Convention => C, Entity => Initialize, External_Name => "nomoInitialize");

   procedure Input (Id   : in Interfaces.C.short;
                    Data : in System.Address);
   pragma Precondition (System."/=" (System.Null_Address, Data));
   pragma Export (Convention => C, Entity => Input, External_Name => "nomoInput");

   procedure Triggers;
   pragma Export (Convention => C, Entity => Triggers, External_Name => "nomoTriggers");

   use Logging_Flags;

   type Log_Position is (Before_Assume, After_Assume);

   procedure Triggers (Flags    : in System.Address;
                       Position : in Log_Position;
                       File     : in File_Flag);
   pragma Export (Convention => C, Entity => Triggers, External_Name => "nomoTriggersWithLog");

   type Finalization_Flag is (Any_Modification, Save_Seed, Update_Seed);
   for Finalization_Flag use (Any_Modification   => 0,
                              Save_Seed          => 1,
                              Update_Seed        => 2);
   pragma Convention (C, Finalization_Flag);

   procedure Finalize (Flag : in Finalization_Flag);
   pragma Export (Convention => C, Entity => Finalize, External_Name => "nomoFinalize");

end Nomo.Interpreter.Kernel;
