--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Plant.Chunks_Index;

private package Nomo.Interpreter.Plant.Affectation_Manager is

   procedure New_Update;

   procedure New_Affectation;

   use Chunks_Index;

   procedure Set_Internal_Operation (I         : in Internal_Chunk_Index;
                                     Operation : in Positive);

   procedure Set_External_Operation (Operation : in Positive);

   function Has_Targeted_Internal return Boolean;

   function Get_Affected_Chunk return Chunk_Index;

   function Get_Created_Perception return Internal_Chunk_Index;

   function Get_Reference_Chunk return Chunk_Index;

   function Has_Reference_Chunk return Boolean;

   function Get_Targeted_Internal_Chunk return Internal_Chunk_Index;

   function Perception_Is_Present return Boolean;

   function Is_Reference_And_Origin return Boolean;

end Nomo.Interpreter.Plant.Affectation_Manager;
