--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Storages.Writing;

with Nomo.Interpreter.Rules_Base.Spontaneous.Logging;

with Nomo.Interpreter.Standard_Conditions.Logging;

package body Nomo.Interpreter.Prediction_Rules.Logging is

   use Rules_Base.Spontaneous.Logging;
   use Standard_Conditions.Logging;

   procedure Log_Full (This       : in Prediction_Rule;
                       Buffer_Ptr : not null access Full_Rule_Storage) is
      use Internal_Messages;
      use Storages.Writing;
   begin
      Log_Partial (This, Buffer_Ptr);
      Log_Full (This.Condition, Buffer_Ptr);
      Set_Internal_Conclusion (Buffer_Ptr.all, Internal_Message(This.Conclusion));
   end Log_Full;

   procedure Log_Partial (This       : in Prediction_Rule;
                          Buffer_Ptr : not null access Full_Rule_Storage) is
   begin
      Log_Partial (This.Condition, Buffer_Ptr);
      Log_Partial (Spontaneous_Rule (This), Buffer_Ptr);
   end Log_Partial;

end Nomo.Interpreter.Prediction_Rules.Logging;
