--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Premises_Index.Arrays;

package Nomo.Interpreter.Premises_Index.Focus.Directories.Initialization is

   use Types_Index.Ranges;

   function Get_Prediction_Index (This            : in Premises_Directory;
                                  Prediction_Type : in Prediction_Type_Index) return Premise_Index;
   pragma Postcondition (Get_Prediction_Index'Result > 0);

   function Get_First_Landmark_Index (This : in Premises_Directory) return Premise_Index;

   function Get_Second_Landmark_Index (This : in Premises_Directory) return Premise_Index;

   use Premises_Index.Arrays;

   procedure Initialize (This            : in out Premises_Directory;
                         Internal_Types  : in Internal_Premises_Types;
                         Last_Premises   : in Internal_Premises_Properties;
                         Premises_Number : in Premise_Index);

end Nomo.Interpreter.Premises_Index.Focus.Directories.Initialization;
