--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

package body Nomo.Interpreter.Rules_Base is

   procedure Adjust (This : in out Rule_Base;
                     Rate : in Real_Accurately_0_To_1) is
   begin
      This.Relevance := This.Relevance + Rate * This.Expectancy_Factor;
   end Adjust;

   Forget : constant Real_Accurately_0_To_1 := Beginning.Parameters.Get_Forget;

   function Is_Forget (This : in Rule_Base) return Boolean is
   begin
      return This.Relevance <= Forget;
   end Is_Forget;

   function Is_Updatable (This : in Rule_Base) return Boolean is
   begin
      pragma Assert (This.Is_Updatable or (not This.Is_Updatable and (This.Relevance = 1.0)));
      return This.Is_Updatable;
   end Is_Updatable;

end Nomo.Interpreter.Rules_Base;
