--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Reader;

with Nomo.Interpreter_Parameters;

package body Nomo.Reader.Parameters is

   use Interpreter_Parameters;

   function Get_Check_Cover return Positive_Real is
      Data : Dynamic_Parameters;
   begin
      Dynamic_Parameters'Read (Reader.Get_Binary_Stream (Dynamic), Data);
      return Data.Check_Cover / 2.0;
   end Get_Check_Cover;

   function Get_Bid_Rate return Real_Accurately_0_To_1 is
      Data : Dynamic_Parameters;
   begin
      Dynamic_Parameters'Read (Reader.Get_Binary_Stream (Dynamic), Data);
      return Data.Bid_Rate;
   end Get_Bid_Rate;

   function Get_Tax_Rate return Real_Accurately_0_To_1 is
      Data : Dynamic_Parameters;
   begin
      Dynamic_Parameters'Read (Reader.Get_Binary_Stream (Dynamic), Data);
      return Data.Tax_Rate;
   end Get_Tax_Rate;

   function Get_Reimbursement_Rate return Real_Accurately_0_To_1 is
      Data : Dynamic_Parameters;
   begin
      Dynamic_Parameters'Read (Reader.Get_Binary_Stream (Dynamic), Data);
      return Data.Reimbursement_Rate;
   end Get_Reimbursement_Rate;

   function Get_Reward_Rate return Real_Accurately_0_To_1 is
      Data : Dynamic_Parameters;
   begin
      Dynamic_Parameters'Read (Reader.Get_Binary_Stream (Dynamic), Data);
      return Data.Reward_Rate;
   end Get_Reward_Rate;

   function Get_Forget return Real_Accurately_0_To_1 is
      Data : Dynamic_Parameters;
   begin
      Dynamic_Parameters'Read (Reader.Get_Binary_Stream (Dynamic), Data);
      return Data.Forget;
   end Get_Forget;

   function Get_Maximum_Of_Components return Positive is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Maximum_Of_Components;
   end Get_Maximum_Of_Components;

   function Get_Maximum_Of_External_Events return Positive is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Maximum_Of_External_Events;
   end Get_Maximum_Of_External_Events;

   function Get_Maximum_Of_Internal_Events return Positive is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Maximum_Of_Internal_Events;
   end Get_Maximum_Of_Internal_Events;

   function Get_Maximum_Of_Premises return Positive is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Maximum_Of_Premises;
   end Get_Maximum_Of_Premises;

   function Get_Maximum_Of_Rules_By_Type return Positive is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Maximum_Of_Rules_By_Type;
   end Get_Maximum_Of_Rules_By_Type;

   function Get_Maximum_Of_Maximizations return Count is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Maximum_Of_Maximizations;
   end Get_Maximum_Of_Maximizations;

   function Get_Number_Of_External_Scopes return Natural is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Number_Of_External_Scopes;
   end Get_Number_Of_External_Scopes;

   function Get_Number_Of_Internal_Scopes return Natural is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Number_Of_Internal_Scopes;
   end Get_Number_Of_Internal_Scopes;

   function Get_Number_Of_External_Operators return Natural is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Number_Of_External_Operators;
   end Get_Number_Of_External_Operators;

   function Get_Number_Of_Internal_Operators return Natural is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Number_Of_Internal_Operators;
   end Get_Number_Of_Internal_Operators;

   function Get_Time_Span_Limit return Positive_Time_Interval is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Data.Time_Span_Limit;
   end Get_Time_Span_Limit;

   function Get_Period return Positive_Time is
      Data : Engine_Parameters;
   begin
      Engine_Parameters'Read (Reader.Get_Binary_Stream (Engine), Data);
      return Positive_Time (1000.0 / Data.Frequency);
   end Get_Period;

   function Get_Types_Directory return Types_Directory is
      Data : Types_Directory;
   begin
      Types_Directory'Read (Reader.Get_Binary_Stream (Types), Data);
      return Data;
   end Get_Types_Directory;

end Nomo.Reader.Parameters;
