--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages.Premises.Printing;

package body Nomo.Gen_Premises_Index.Arrays.Printing is

   function Get_Property (Properties : in Internal_Premises_Properties;
                          I          : in Premise_Index) return Premise_Property;
   pragma Precondition (I > 0);

   function Get_Property (Properties : in Internal_Premises_Properties;
                          I          : in Premise_Index) return Premise_Property is
   begin
      for J in Premise_Property'Range loop
         if I <= Properties (J) then
            return J;
         end if;
      end loop;
      raise Constraint_Error;
   end Get_Property;

   package body CVS is

      package Internal_Messages_Premises_Printing is new Internal_Messages.Premises.Printing.CVS (Internal_Type_Index);
      use Internal_Messages_Premises_Printing;

      procedure Put_Header (File : in out File_Type) is
      begin
         for I in 1..Premise_Index'Last loop
            Put_Header (File, Positive (I));
         end loop;
      end Put_Header;

      procedure Put (File         : in out File_Type;
                     Premises     : in Internal_Premises;
                     Types        : in Internal_Premises_Types;
                     Properties   : in Internal_Premises_Properties;
                     Last_Premise : in Premise_Index) is
      begin
         for I in 1..Premise_Index'Last loop
            if I <= Last_Premise then
               Put (File, Premises (I), Get_Category (Types (I)), Types (I), Get_Property (Properties, I));
            else
               Put_NA (File);
            end if;
         end loop;
      end Put;

   end CVS;

   package body XML is

      package Internal_Messages_Premises_Printing is new Internal_Messages.Premises.Printing.XML (Internal_Type_Index);

      procedure Put (File         : in out File_Type;
                     Premises     : in Internal_Premises;
                     Types        : in Internal_Premises_Types;
                     Properties   : in Internal_Premises_Properties;
                     Last_Premise : in Premise_Index) is
         use Internal_Messages_Premises_Printing;
      begin
         for I in 1..Last_Premise loop
            Put (File, Premises (I), Get_Category (Types (I)), Types (I), Get_Property (Properties, I));
         end loop;
      end Put;

   end XML;


   package body DB is

      package Internal_Messages_Premises_Printing is new Internal_Messages.Premises.Printing.DB (Internal_Type_Index);

      use Numerics.Times;

      procedure Put (File         : in out File_Type;
                     T            : in Time;
                     Rule_Id      : in Positive;
                     Premises     : in Internal_Premises;
                     Types        : in Internal_Premises_Types;
                     Properties   : in Internal_Premises_Properties;
                     Last_Premise : in Premise_Index) is
         use Internal_Messages_Premises_Printing;
      begin
         for I in 1..Last_Premise loop
            Put (File, T, Rule_Id, Premise_Index'Image (I), Premises (I), Types (I), Get_Property (Properties, I));
         end loop;
      end Put;

   end DB;
end Nomo.Gen_Premises_Index.Arrays.Printing;
