--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Ada.Text_IO;

with Nomo.Type_Categories;
use Nomo.Type_Categories;

with Nomo.Numerics.Times;

generic
   with function Get_Category (I : in Internal_Type_Index) return Type_Category;
package Nomo.Gen_Rule_Storages.Partial_Printing is

   use Ada.Text_IO;
   use Numerics.Times;

   package CVS is

      procedure Put_Header (File : in out File_Type);

      procedure Put (File : in out File_Type;
                     This : in Partial_Rule_Storage;
                     T    : in Time);

   end CVS;

   package XML is

      procedure Put_Header (File : in out File_Type);

      procedure Put (File : in out File_Type;
                     This : in Partial_Rule_Storage;
                     T    : in Time);

      procedure Put_Ending (File : in out File_Type);

   end XML;

   package DB is

      procedure Create (Path : in string);

      procedure Open (Path : in string);

      procedure Put (This : in Partial_Rule_Storage;
                     T    : in Time);

      procedure Close;

   private

      Log   : File_Type;
      Rule : File_Type;

      procedure Open_Rule (Path : in String);

   end DB;

end Nomo.Gen_Rule_Storages.Partial_Printing;
