/* Interface for nomoInterpreter created with nomoSDK */

import com.sun.jna.Pointer;
  
public class HelloWorld {

    /* Size of inputs and commands */
    public static enum DataSize{
        COMMAND_LABEL_MHELLOWORLD (1);  // program: pHelloWorld model: mHelloWorld
        private final int size;
        private DataSize(int value) {
            size = value;
        }
        public int getSize() {
            return size;
        }
    }

    /* Components of inputs and components of commands */
    public static enum commandLabelMHelloWorldComponent {VALUE}

   /* Command functions */
    public static void commandLabelMHelloWorld(final float intensity, final Pointer data){
/*
      System.out.println("commandLabelMHelloWorld ->");
      System.out.println("intensity : " + intensity);
      for (int i = 0; i < DataSize.COMMAND_LABEL_MHELLOWORLD.getSize(); i++) {
            System.out.println("data [" + i + "] : " + data.getFloat(i*Float.SIZE));
      }
*/
      if (data.getFloat(commandLabelMHelloWorldComponent.VALUE.ordinal()*Float.SIZE) == 1.0)
           System.out.println("Hello World !");
    }

    public static final NomoInterpreter.NomoCallback [] callbacks = new NomoInterpreter.NomoCallback [] {
        new NomoInterpreter.NomoCallback() { public void invoke( float intensity,  Pointer  data) { commandLabelMHelloWorld(intensity, data); } }
	
    };

    /* ID of log types */
    public static enum LogId {
        COMMAND_LABEL_MHELLOWORLD; // program: pHelloWorld model: mHelloWorld
    }

    public static final int TYPES_LOG_NUMBER = 1;

}