cd %~dp0
if exist nomotools.so del nomotools.so
if exist nomotools.dll del nomotools.dll
if exist nomotools.exe del nomotools.exe
if exist libxml2.dll copy ..\..\bin\libxml2.dll
if exist libxslt.dll copy ..\..\bin\libxslt.dll

cd ../../src/nomotools

echo Build dynamic library nomotools

gnatmake -v -z nomotools.adb -I. -I../nomointerpreter -I../basic_sax -cargs -gnatw.edl -gnatf -gnat05 -gnatyabcefhiklrs -gnatQ -fdata-sections -ffunction-sections -O2 -gnatVn -gnatp -gnatn -funroll-loops -bargs -n -x -v -Lnomotools -largs -s -g -Wl -fPIC --gc-sections

REM debug: gnatmake -v -z nomotools.adb -I. -I../nomointerpreter -I../basic_sax -cargs -g -gnatw.edl -gnatf -gnat05 -gnatyabcefhiklrs -gnatQ -fdata-sections -ffunction-sections -O0 -gnatVn -g -gnato -fstack-check -gnatE -fcallgraph-info=su,da -gnata

gnatbind -n -x nomotools.ali -Lnomotools
gnatlink -g -mdll -s -o nomotools.dll nomotools.ali -Xlinker --base-file=nomotools.base
dlltool --dllname nomotools.dll --base-file nomotools.base --output-exp nomotools.exp --def nomotools.def
gnatlink -g -mdll -s -o nomotools.dll nomotools.ali -Xlinker --base-file=nomotools.base nomotools.exp
dlltool --dllname nomotools.dll --base-file nomotools.base --output-exp nomotools.exp --def nomotools.def
gnatlink -g -mdll -s -o nomotools.dll nomotools.ali -Xlinker nomotools.exp

echo Build a Microsoft-style import library
set PATH=../../bin;%PATH%

lib -machine:IX86 -def:nomotools.def -out:nomotools.lib >save.txt

del b~nomotools.ads
del b~nomotools.adb
del b~nomotools.ci
del nomotools.base
del nomotools.exp
del save.txt
del *.o
del *.ali
del *.exe

mv nomotools.lib ../../lib/

echo Build executable nomotools

set PATH=C:\Qt\4.8.4\bin;%PATH%
set PATH=C:\Program Files\Microsoft Visual Studio 10.0\VC\bin;%PATH%
set PATH=C:\Program Files\Microsoft Visual Studio 10.0\Common7\IDE;%PATH%
set PATH=C:\Program Files\Microsoft SDKs\Windows\v7.0A\bin;%PATH%
set WINDOWSSDKDIR=C:\Program Files\Microsoft SDKs\Windows\v7.0A\
set LIB=C:\Program Files\Microsoft SDKs\Windows\v7.0A\lib;%LIB%
set INCLUDE=C:\Program Files\Microsoft SDKs\Windows\v7.0A\include;%INCLUDE%
set VCINSTALLDIR=c:\Program Files\Microsoft Visual Studio 10.0\VC\
set VS100COMNTOOLS=c:\Program Files\Microsoft Visual Studio 10.0\Common7\Tools\
set QMAKESPEC=win32-msvc2010
set PSMODULEPATH=C:\Windows\system32\WindowsPowerShell\v1.0\Modules\
set QTDIR=C:/Qt/4.8.4

qmake -spec c:\Qt\4.8.4\mkspecs\win32-msvc2010
nmake

mv release/nomotools.exe .
rm -rf release
rm -rf debug
del Makefile.Release
del Makefile.Debug
del Makefile

mv nomotools.exe ../../build/nomotools
mv nomotools.dll ../../build/nomotools

cd ../../build/nomointerpreter/helloworld
copy HelloWorld.uni ..\..\nomotools\helloworld
cd ../../nomotools/helloworld
if exist ../nomotools.exe call helloworld.bat
cd ..
cd ../nomotime
if not exist nomotime.exe call build.bat
copy nomointerpreter.dll ..\nomotools
copy nomotime.exe ..\nomotools
