--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

private generic
   Number_Of_External_Scopes : Natural;
   Number_Of_Internal_Scopes : Natural;
   Number_Of_External_Types   : Natural;
   Number_Of_Internal_Types   : Natural;
   type External_Type_Index is (<>);
   type Internal_Type_Index is (<>);
package Nomo.Gen_Scopes is

   pragma Pure;

   type External_Types is array (1 .. Number_Of_External_Types) of External_Type_Index;
   type External_Scope is record
      Last : Natural;
      List : External_Types;
   end record;
   type External_Scopes is array (1 .. Number_Of_External_Scopes) of External_Scope;

   type Internal_Types is array (1 .. Number_Of_Internal_Types) of Internal_Type_Index;
   type Internal_Scope is record
      Last : Natural;
      List : Internal_Types;
   end record;
   type Internal_Scopes is array (1 .. Number_Of_Internal_Scopes) of Internal_Scope;

end Nomo.Gen_Scopes;
