--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Gen_Rules_Directories.Linking;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Linking);

package body Nomo.Interpreter.Gen_Clusters_Base.Commanding_Loading is

   procedure Initialize_Links (This   : in out Cluster_Base;
                               Target : in Perceptions_Cluster) is

      package Local_Linking is new Local_Rules_Directories.Linking (Get_Perception_Information,
                                                                    Perceptions_Cluster,
                                                                    Perceptive_Rule,
                                                                    Get_Perception,
                                                                    Set_Linked_Perception);
      use Local_Linking;
   begin
      Initialize_Links (Rules_Directory (This.Directory), Target);
   end Initialize_Links;

   function Has_Space (This : in Cluster_Base) return Boolean is
   begin
      return Local_Insertion.Has_Space (Rules_Directory (This.Directory));
   end Has_Space;

   procedure Load (This             : in out Cluster_Base;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage;
                   Last_Loaded      : out Rule_Ptr) is
      use Local_Insertion;
      Excitatory_Specificity_Log : Real_Accurately;
      Inhibitory_Specificity_Log : Real_Accurately;
   begin
      Last_Loaded := Get_New_Reference(Rules_Directory (This.Directory));
      Initialize (Last_Loaded.all, Rule_Storage_Ptr.all, This.Matchmaker'Access, Excitatory_Specificity_Log, Inhibitory_Specificity_Log);
      Insert(Rules_Directory (This.Directory), Excitatory_Specificity_Log, Inhibitory_Specificity_Log);
   end Load;

end Nomo.Interpreter.Gen_Clusters_Base.Commanding_Loading;
