--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Numerics.Informations;

private package Nomo.Interpreter.Maximums_Register is

   use Types_Index.Ranges;
   use Numerics.Informations;

   package Initialization is

      procedure Set_New_Information (I           : in Internal_Type_Index;
                                     Information : in Positive_Integer);

      procedure Adjust_Information_Perceptive_Max;

      procedure Set_New_Rule_Id (Rule_Id : in Positive);

   end Initialization;

   package Incrementation is

      function Get_New_Information (I : in Internal_Type_Index) return Positive_Integer;

      function Get_Last_Information (I : in Perception_Type_Index) return Positive_Integer;

      function Get_New_Rule_Id return Positive;

   end Incrementation;

end Nomo.Interpreter.Maximums_Register;
