--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;

with Nomo.Numerics.Fitting;

with Nomo.Numerics.Times;

with Nomo.Gen_Types_Directories;

package Nomo.Reader.Parameters is

   use Numerics.Accurately;

   use Numerics.Reals;

   function Get_Check_Cover return Positive_Real;

   function Get_Bid_Rate return Real_Accurately_0_To_1;

   function Get_Tax_Rate return Real_Accurately_0_To_1;

   function Get_Reimbursement_Rate return Real_Accurately_0_To_1;

   function Get_Reward_Rate return Real_Accurately_0_To_1;

   function Get_Forget return Real_Accurately_0_To_1;

   function Get_Maximum_Of_Components return Positive;

   function Get_Maximum_Of_External_Events return Positive;

   function Get_Maximum_Of_Internal_Events return Positive;

   function Get_Maximum_Of_Premises return Positive;

   function Get_Maximum_Of_Rules_By_Type return Positive;

   use Numerics.Fitting;

   function Get_Maximum_Of_Maximizations return Count;

   function Get_Number_Of_External_Scopes return Natural;

   function Get_Number_Of_Internal_Scopes return Natural;

   function Get_Number_Of_External_Operators return Natural;

   function Get_Number_Of_Internal_Operators return Natural;

   use Numerics.Times;

   function Get_Time_Span_Limit return Positive_Time_Interval;

   function Get_Period return Positive_Time;
   pragma Postcondition (Get_Period'Result > 0);

   generic
      with package Types_Directories is new Gen_Types_Directories (<>);
      use Types_Directories;
   function Get_Types_Directory return Types_Directory;

end Nomo.Reader.Parameters;
