﻿<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdk="http://www.nomoseed.org/nomosdk" xmlns="http://www.w3.org/1999/xhtml">
	<xsl:output method="xml" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" standalone="yes" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" indent="no" encoding="utf-8"/>
	<xsl:param name="open" select="'Open'"/>
	<xsl:param name="project" select="'A project'"/>
	<xsl:param name="database" select="'A database'"/>
	<xsl:param name="create" select="'Create'"/>
	<xsl:param name="unit" select="'Unit'"/>
	<xsl:param name="knowledge_base" select="'Knowledge base'"/>
	<xsl:param name="map" select="'Map'"/>
	<xsl:param name="model" select="'Model'"/>
	<xsl:param name="inference_engine" select="'Inference engine'"/>
	<xsl:param name="program" select="'Program'"/>
	<xsl:param name="warning" select="'The project name must begin with a letter possibly followed by any alphanumeric characters or underscores.'"/>
	<xsl:param name="name" select="'Name'"/>
	<xsl:param name="location" select="'Choose location'"/>
	<xsl:param name="legalNotice" select="'Legal notice:'"/>
	<xsl:template match="/sdk:reception">
		<html id="reception" class="background">
			<head>
				<title>Reception</title>
				<link rel="stylesheet" type="text/css" href="../share/nomoSDK.css"/>
				<link rel="stylesheet" type="text/css" href="reception.css"/>
				<script type="application/ecmascript" src="reception.js"/>
			</head>
			<body>
				<div id="open" class="box">
					<p>
						<xsl:value-of select="$open"/>
					</p>
					<form action="">
						<fieldset>
							<input id="project" class="heavy big" type="button" value="{$project}"/>
							<input id="database" class="heavy big" type="button" value="{$database}"/>
						</fieldset>
					</form>
				</div>
				<div id="create" class="box">
					<p>
						<xsl:value-of select="$create"/>
					</p>
					<form action="">
						<fieldset>
              <div id="chooseBasicType" class="decoration">
							<input class="light" type="radio" value="uni" name="type" id="unit" checked="checked"/>
							<label class="light" for="unit">
								<xsl:value-of select="$unit"/>
							</label>
							<input class="light" type="radio" value="mod" name="type" id="model"/>
							<label class="light" for="model">
								<xsl:value-of select="$model"/>
							</label>
							<input class="light" type="radio" value="prg" name="type" id="program"/>
							<label class="light" for="program">
								<xsl:value-of select="$program"/>
							</label>
							<input class="light" type="radio" value="eng" name="type" id="inference_engine"/>
							<label class="light" for="inference_engine">
								<xsl:value-of select="$inference_engine"/>
							</label>
							<input class="light" type="radio" value="bas" name="type" id="knowledge_base"/>
							<label class="light" for="knowledge_base">
								<xsl:value-of select="$knowledge_base"/>
							</label>
              </div>
              <div id="chooseOtherType" class="decoration">
							<input class="light" type="radio" value="map" name="type" id="map"/>
							<label class="light" for="map">
								<xsl:value-of select="$map"/>
							</label>
								<xsl:for-each select="sdk:formalism/sdk:item">
                <input class="light" type="radio" value="{@value}" name="type" id="{@value}"/>
                <label class="light" for="{@value}">
                  <xsl:value-of select="@label"/>
                </label>
								</xsl:for-each>
              </div>
						</fieldset>
						<fieldset>
            <div id="chooseLocation" class="decoration">
							<input type="text" placeholder="{$name}" id="name" pattern="[a-zA-Z]+[a-zA-Z0-9_]*"/>
							<label for="name" ><xsl:value-of select="$warning"/></label>
							<input type="button" class="heavy big limited" value="{$location}" disabled="disabled" id="location"/>
              </div>
						</fieldset>
					</form>
				</div>
				<div id="footer" class="box">
					<div id="legalNotice">
						<p>
							<xsl:value-of select="$legalNotice"/>
						</p>
					</div>
					<div id="chooseLanguage">
						<form action="">
							<fieldset>
								<select id="language">
									<xsl:for-each select="sdk:language/sdk:item">
										<xsl:choose>
											<xsl:when test="@value='none'">
												<option value="{@value}" selected="selected">
													<xsl:value-of select="@label"/>
												</option>
											</xsl:when>
											<xsl:otherwise>
												<option value="{@value}">
													<xsl:value-of select="@label"/>
												</option>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:for-each>
								</select>
							</fieldset>
						</form>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
